<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Car Care</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .hero-section {
            background: url('https://source.unsplash.com/1920x1080/?car,modern') no-repeat center center;
            background-size: cover;
            height: 70vh;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            position: relative;
        }

        .service-card:hover {
            transform: translateY(-5px);
        }

        .btn-primary {
            background: #007bff;
            color: #fff;
            border: none;
            padding: 0.75rem 2rem;
            font-weight: 600;
            transition: background 0.3s;
        }

        .btn-outline-primary {
            border-color: #007bff;
            color: #007bff;
            padding: 0.75rem 2rem;
            font-weight: 600;
        }

        .feature-card, .service-card {
            background: #fff;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 123, 255, 0.1);
            transition: transform 0.3s;
        }

        .container-fluid {
            padding: 0;
            margin: 0;
        }
    </style>
</head>
<body>

<!-- Hero Section -->
<div class="hero-section">
    <div style="background: rgba(255, 255, 255, 0.95); padding: 3rem; border-radius: 10px; box-shadow: 0 4px 15px rgba(0, 123, 255, 0.2); max-width: 800px;">
        <h1 style="font-family: 'Arial', sans-serif; font-size: 2.8rem; color: #007bff; font-weight: bold;">Welcome to Car Care</h1>
        <p style="font-size: 1.4rem; color: #333; margin: 1rem 0;">Professional Home Car Services</p>
        <p style="font-size: 1.1rem; color: #666;">Experience hassle-free maintenance at your doorstep—designed for car lovers, by car lovers.</p>
        <div class="mt-4">
            <a href="<?php echo e(route('booking.create')); ?>" class="btn btn-lg btn-primary">Book a Service</a>
        </div>
    </div>
</div>

<!-- Features Section -->
<div class="container py-5">
    <h2 class="text-center" style="font-family: 'Arial', sans-serif; color: #007bff; font-size: 2.2rem; font-weight: bold; margin-bottom: 3rem;">Why Choose Us?</h2>
    <div class="row text-center">
        <div class="col-md-4 mb-4">
            <div class="service-card">
                <i class="fas fa-tools" style="font-size: 2.5rem; color: #007bff;"></i>
                <h3 style="color: #333; margin: 1rem 0; font-size: 1.5rem; font-weight: 600;">🛢️ Engine Oil Change</h3>
                <p style="color: #666;">Quick, clean oil changes using top-grade motor oil.</p>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="service-card">
                <i class="fas fa-tachometer-alt" style="font-size: 2.5rem; color: #007bff;"></i>
                <h3 style="color: #333; margin: 1rem 0; font-size: 1.5rem; font-weight: 600;">⚙️ Gearbox Oil Change</h3>
                <p style="color: #666;">Protect your transmission with a smooth gearbox oil service.</p>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="service-card">
                <i class="fas fa-tire" style="font-size: 2.5rem; color: #007bff;"></i>
                <h3 style="color: #333; margin: 1rem 0; font-size: 1.5rem; font-weight: 600;">🛞 Puncture Tire Fix</h3>
                <p style="color: #666;">Fast tire repairs right at your home, no towing needed.</p>
            </div>
        </div>
    </div>
</div>

<!-- Call to Action -->
<div class="container-fluid py-5" style="background: #007bff; text-align: center;">
    <h2 style="font-family: 'Arial', sans-serif; color: #fff; font-size: 2.2rem; font-weight: bold; margin-bottom: 1.5rem;">Drive Worry-Free</h2>
    <p style="font-size: 1.3rem; color: #e6f0ff;">Sign up today for top-tier car care at your convenience.</p>
    <a href="" class="btn btn-lg btn-light" style="color: #007bff; padding: 0.75rem 2rem; font-weight: 600;">Join Now</a>
</div>

<!-- Font Awesome for Icons -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
<?php /**PATH C:\laragon\www\servicegpt\car-service\resources\views/welcome.blade.php ENDPATH**/ ?>